<?php

include 'enableCORS.php';
defined('BASEPATH') OR exit('No direct script access allowed');

require APPPATH .  '/libraries/REST_Controller.php';

Class Orden extends REST_Controller {

	public function __construct(){
        
		enableCORS();
		parent::__construct();

		$this->load->database();	
		$this->load->model('Orden_model');

	}		

	/*
	|------------------------------------
	| LISTA DE COMUNAS GET
	| SE OMITE PORQUE SE INSERTARA STGO POR DEFECTO
	|------------------------------------
	*/
	/*public function getComunas_get(){

		
		$comunas = $this->Orden_model->mdl_comunas();

		if(isset($comunas)){

			$respuesta = array(
					'err'     => FALSE,
					'mensaje' => 'Registros cargado exitosamente',
					'comunas' => $comunas					
			);

			$this->response($respuesta);	

		}else{

			$respuesta = array(
					'err'     => TRUE,
					'mensaje' => 'Problemas al cargar las comunas',
					'comunas' => null
					
			);

			$this->response($respuesta, REST_Controller::HTTP_NOT_FOUND);
		}
	}*/
	//-----------------------------------

	/*
	|------------------------------------
	| LISTA DE LAS FORMA DE PAGO GET
	|------------------------------------
	*/
	public function getFormaPago_get(){
		
		$FormaPago = $this->Orden_model->mdl_forma_pago();

		if(isset($FormaPago)){

			$respuesta = array(
					'err'       => FALSE,
					'mensaje'   => 'Registros cargado exitosamente',
					'FormaPago' => $FormaPago					
			);

			$this->response($respuesta);	

		}else{

			$respuesta = array(
					'err'       => TRUE,
					'mensaje'   => 'Problemas al cargar las Forma de Pago',
					'FormaPago' => null
					
			);

			$this->response($respuesta, REST_Controller::HTTP_NOT_FOUND);
		}
	}
	//-----------------------------------

	/*
	|------------------------------------
	| LISTA DE TIPO DE COMPRA VENTA GET
	|------------------------------------
	*/
	public function getTipoCmpVta_get(){
		
		$TipoCV = $this->Orden_model->mdl_tipo_orden();

		if(isset($TipoCV)){

			$respuesta = array(
					'err'       => FALSE,
					'mensaje'   => 'Registros cargado exitosamente',
					'TipoCV'    => $TipoCV					
			);

			$this->response($respuesta);	

		}else{

			$respuesta = array(
					'err'       => TRUE,
					'mensaje'   => 'Problemas al cargar las Tipo Compra Venta',
					'TipoCV'    => null
					
			);

			$this->response($respuesta, REST_Controller::HTTP_NOT_FOUND);
		}
	}
	//-----------------------------------

	/*
	|------------------------------------------
	| LISTA DE MODO DE FACTURACION GET
	|------------------------------------------
	*/
	public function getModoFacturacion_get(){
		
		$ModoFacturacion = $this->Orden_model->mdl_modo_facturacion();

		if(isset($ModoFacturacion)){

			$respuesta = array(
					'err'             => FALSE,
					'mensaje'         => 'Registros cargado exitosamente',
					'ModoFacturacion' => $ModoFacturacion					
			);

			$this->response($respuesta);	

		}else{

			$respuesta = array(
					'err'             => TRUE,
					'mensaje'         => 'Problemas al cargar modo de facturación',
					'ModoFacturacion' => null
					
			);

			$this->response($respuesta, REST_Controller::HTTP_NOT_FOUND);
		}
	}
	//-----------------------------------------

	/*
	|------------------------------------------
	| LISTA DE TIPO DE MONEDAS GET
	|------------------------------------------
	*/
	public function getTipoMoneda_get(){
		
		$TipoMoneda = $this->Orden_model->mdl_tipo_moneda();

		if(isset($TipoMoneda)){

			$respuesta = array(
					'err'             => FALSE,
					'mensaje'         => 'Registros cargado exitosamente',
					'TipoMoneda'      => $TipoMoneda					
			);

			$this->response($respuesta);	

		}else{

			$respuesta = array(
					'err'             => TRUE,
					'mensaje'         => 'Problemas al cargar modo de facturación',
					'TipoMoneda'      => null
					
			);

			$this->response($respuesta, REST_Controller::HTTP_NOT_FOUND);
		}
	}
	//-----------------------------------------
	
	/*
	|------------------------------------------
	| LISTA DE REGISTRO EN FLUJO GET
	|------------------------------------------
	*/
	public function getRegistroFlujo_get(){
	
		$tipo_cta = $this->uri->segment(3);

		//VALIDAMOS QUE INGRESE TIPO DE CUENTA
		if (!isset($tipo_cta)){

			$respuesta = array(
						'err'     => TRUE,
						'mensaje' => 'Es necesario el tipo de cuenta'
			);

			$this->response($respuesta, REST_Controller::HTTP_BAD_REQUEST);
			
			return;
		}
		
		$RegistroFlujo = $this->Orden_model->mdl_registro_flujo($tipo_cta);

		if(isset($RegistroFlujo)){

			$respuesta = array(
					'err'             => FALSE,
					'mensaje'         => 'Registros cargado exitosamente',
					'RegistroFlujo'   => $RegistroFlujo					
			);

			$this->response($respuesta);	

		}else{

			$respuesta = array(
					'err'             => TRUE,
					'mensaje'         => 'Problemas al cargar registro en flujo',
					'RegistroFlujo'   => null
					
			);

			$this->response($respuesta, REST_Controller::HTTP_NOT_FOUND);
		}
	}
	//-----------------------------------------
	
	/*
	|------------------------------------
	| CONSULTA SOCIEDAD POR RUT POST
	| SE OMITE YA QUE SE AGREGA RUT EN EL JSON
	|------------------------------------
	*/
	/*public function CsuSociedad_post(){
		
		$data = $this->post();

		$this->load->library('form_validation');

		$this->form_validation->set_data($data);		

		if($this->form_validation->run('sociedad_csu')){

			$sociedad = $this->Orden_model->set_datos($data);

			$respuesta = $sociedad->mdl_sociedad();			

			if ($respuesta['err']){
				$this->response($respuesta, REST_Controller::HTTP_BAD_REQUEST);				
			}else{
				$this->response($respuesta);
			}			

		}else{		

			$respuesta = array(
					'err'     => TRUE,
					'mensaje' => 'Hay errores en el envio de información',
					'errores' => $this->form_validation->get_errores_arreglo()
			);

			$this->response($respuesta, REST_Controller::HTTP_BAD_REQUEST);
		}
	}*/
	//-----------------------------------

	/*
	|--------------------------------
	| CREACION DE COMPRA & VENTA POST
	|--------------------------------
	*/
	public function GrbCmpVta_post(){

		//Envio Json desde el BODY row		
		$_POST = json_decode(file_get_contents("php://input"), true);

        if($_POST) {

        	$this->load->helper(array('form', 'url', 'utilidades_helper'));
        	
			$sumDet = 0;
			$sumHit = 0;

			/*
			|--------------------------------
			| DATOS POR DEFECTOS - PUEDE QUE CON EL TIEMPO CAMBIEN
			|--------------------------------
			*/
			$ID_Comuna = 291; //STGO
			$RegistroFlujo = ($_POST['CmpVta'] === 2 ? 250 : 249);			
			//-------------------------------

			$errors = valida_obj($_POST,
								 $_POST['detalles'],
								 $_POST['hitos']);

			if(count($errors) > 0){
				
				$respuesta = array(
					'err'     => TRUE,
					'mensaje' => 'Hay errores en el envio de información',							
					'errores' => $errors
				);

				$this->response($respuesta, REST_Controller::HTTP_BAD_REQUEST);

				return;
			}										

    		$orden = $this
        			 ->Orden_model
        			 ->mdl_insert_orden($_POST['Cod_CmpVta'],
        			 					$_POST['CmpVta'],
        			 					$_POST['ID_Soc'],
        			 					$_POST['Rut_Soc'],
        			 					$_POST['EmitidoPor'],
        			 					$_POST['FechaCompra'],
        			 					$_POST['CondicionPago'],
        			 					$_POST['CentroCosto'],
        			 					$_POST['ID_TipoCmpVta'],
        			 					$_POST['cliente']['Rut'],
        			 					$_POST['cliente']['Digito'],
        			 					$_POST['cliente']['Nombre'],
        			 					$_POST['cliente']['Giro'],
        			 					$ID_Comuna,
        			 					$_POST['cliente']['Contacto'],
        			 					$_POST['cliente']['Cargo'],
        			 					$_POST['cliente']['Email'],
        			 					$_POST['cliente']['Telefono'],
        			 					$_POST['cliente']['Celular'],
										$_POST['MonedaOrigen'],
        			 					$_POST['ValorTipoCambio'],
        			 					$_POST['FechaTipoCambio'],
        			 					$_POST['ID_ModoFact'],        			 					
        			 					$_POST['Observacion'],
        			 					$RegistroFlujo);

			if ($orden['err']){				

				if (!$orden['key']){	

					$out = array(
							'err'        => FALSE,
							'mensaje'    => $orden['mensaje'],
							'orden_id'   => $orden['orden_id'],
							'orden_num'  => $orden['orden_num']						
					);	

					$this->response($out);

				}else{

					$this->response($orden, REST_Controller::HTTP_BAD_REQUEST);

				}

			}else{

				foreach($_POST['detalles'] as $det){

					$detalles = $this
							    ->Orden_model
							    ->mdl_insert_detalles($orden['orden_id'],
							    					  $det['Cantidad'],
							    					  (isset($det['UnidadMedida']) ? $det['UnidadMedida'] : 102),
							    					  $_POST['MonedaOrigen'], //La moneda que se seleccione en el encabezado
							    					  $det['CtaContable'],
							    					  $_POST['ID_ModoFact'],
							    					  $det['NetoBruto'],
							    					  $det['PrecioUnitario'],
							    					  $det['PrecioTotal'],
							    					  $det['Descripcion'],  
							    					  $det['Patente']);
				}

				if ($detalles['err']){

					$this->response($detalles, REST_Controller::HTTP_BAD_REQUEST);

				}else{					

					foreach($_POST['hitos'] as $hit){

						$hitos = $this
								 ->Orden_model
								 ->mdl_insert_hitos($orden['orden_id'],
						    					    $hit['ID_FormaPago'],
						    					    $hit['HitoPago'],
						    					    $hit['MontoNetoOrigen'],
						    					    $hit['MontoExentoOrigen'],
						    					    $hit['MontoIVAOrigen'],
						    					    $hit['MontoTotalOrigen'],	    
						    					    $hit['MontoNetoNacional'],
						    					    $hit['MontoExentoNacional'],
						    					    $hit['MontoIVANacional'],
						    					    $hit['MontoTotalNacional'],	    
						    					    $RegistroFlujo, 
						    					    $hit['FechaPago']);
					}												 

					if ($hitos['err']){

						$this->response($hitos, REST_Controller::HTTP_BAD_REQUEST);

					}else{

						$this->Orden_model->mdl_sol_apb_vta($orden['orden_id']);						

						$this->response($orden);					
					}
				}
			}			

        }else {

        	$respuesta = array(
					'err'     => TRUE,
					'mensaje' => 'Hay errores en el envio de información',
					'errores' => array(array('errors' => 'Problemas de envio Json desde el BODY'))
			);

            http_response_code(405);
            $this->response($respuesta, REST_Controller::HTTP_BAD_REQUEST);
        }
	}
	//-------------------------------	
}