<?php

function capitalizar_arreglo( $data_cruda, $campos_capitalizar ){

	$data_lista = $data_cruda;

	foreach ($data_cruda as $nombre_campo => $valor_campo) {
		# code...
		if ( in_array($nombre_campo, array_values($campos_capitalizar))){

			$data_lista[ $nombre_campo ] = strtoupper($valor_campo);

		}
	}

	return $data_lista;

}

function date_valid($date)
{
    $_ci = &get_instance();

    $parts = explode("-", $date);

    if (count($parts) == 3) {      
      if (checkdate($parts[1], $parts[2], $parts[0]))
      {
        return TRUE;
      }
    }

    //$_ci->form_validation->set_message('date_valid', 'El campo Fecha debe ser yyyy-mm-dd');

    return false;
}

function validar_fecha_espanol($fecha){

	$valores = explode('-', $fecha);
	
	if(count($valores) == 3 && checkdate($valores[1], $valores[2], $valores[0])){
		
		return true;
    }
	return false;
}

function valida_obj($orden,$detalles,$hitos)
{
  $_ci = &get_instance();

  $sumDet = 0;
  $sumHit = 0;

  $errors = array();  	

  /*
	|--------------------------------------
	| VALIDAR ENCABEZADO
	|--------------------------------------
	*/

	if($orden['Cod_CmpVta'] == ""){
		$errors[] = array("errors" => "El campo Cod_CmpVta es obligatorio.");	
	}else{
		if (!is_int($orden['Cod_CmpVta'])){
  		$errors[] = array("errors" => "El campo Cod_CmpVta debe ser entero");
  	}else{
  		if ($orden['Cod_CmpVta'] == 0) {
  			$errors[] = array("errors" => "El campo Cod_CmpVta no puede ser 0");
  		}
  	}
	}	

	if($orden['CmpVta'] == ""){
		$errors[] = array("errors" => "El campo CmpVta es obligatorio.");	
	}else{
		if (!is_int($orden['CmpVta'])){
  		$errors[] = array("errors" => "El campo CmpVta debe ser entero");
  	}else{
  		if ($orden['CmpVta'] <> 1 && $orden['CmpVta'] <> 2) {
  			// code...
  			$errors[] = array("errors" => "Código ingresado en el campo CmpVta no es valido " . $orden['CmpVta']);
  		}
  	}
	}	

	if($orden['ID_Soc'] == "" && $orden['Rut_Soc'] == ""){
			$errors[] = array("errors" => "Debe ingresar al menos ID_Soc o Rut_Soc es obligatorio.");	
	}else{
		if (!is_int($orden['ID_Soc'])){
  		$errors[] = array("errors" => "El campo ID_Soc debe ser entero");
  	}else{
  		if($orden['ID_Soc'] <> 0){
	  		$query = $_ci->db->get_where('tab_scd_per', array('tsp_cod_sdp' => $orden['ID_Soc']));	
				$sociedad = $query->row();

				if (!isset($sociedad))
				{		
					$errors[] = array("errors" => "Código ID_Soc: '" . $orden['ID_Soc'] . "' de Sociedad no se encuentra registrado");	
				}
			}
  	}

  	if (!is_int($orden['Rut_Soc'])){
  		$errors[] = array("errors" => "El campo Rut_Soc debe ser entero");
  	}else{
  		if($orden['Rut_Soc'] <> 0){
	  		$query = $_ci->db->get_where('tab_scd_per', array('tsp_rut_sdp' => $orden['Rut_Soc']));	
				$sociedad = $query->row();

				if (!isset($sociedad))
				{		
					$errors[] = array("errors" => "RUT: '" . $orden['Rut_Soc'] . "' de Sociedad no se encuentra registrado");	
				}
			}
  	}
	}	
	
	if(trim($orden['EmitidoPor']) == ""){
  	$errors[] = array("errors" => "El campo EmitidoPor es obligatorio");
  }

  if(trim($orden['FechaCompra']) == ""){
  	$errors[] = array("errors" => "El campo FechaCompra es obligatorio");
  }elseif(!date_valid($orden['FechaCompra'])){
  	$errors[] = array("errors" => "El campo FechaCompra debe ser yyyy-mm-dd");
  }

  if(trim($orden['CondicionPago']) == ""){
  	$errors[] = array("errors" => "El campo CondicionPago es obligatorio");
  }

  /*if(trim($orden['CentroCosto']) == ""){
  	$errors[] = array("errors" => "El campo CentroCosto es obligatorio");
  }elseif(strlen($orden['CentroCosto']) > 8){
  	$errors[] = array("errors" => "El campo CentroCosto no puede ser mayor a 8 carácteres");
  }*/

  if(strlen($orden['CentroCosto']) > 8){
  	$errors[] = array("errors" => "El campo CentroCosto no puede ser mayor a 8 carácteres");
  }

  if($orden['ValorTipoCambio'] == "" || $orden['ValorTipoCambio'] == "0"){
		$errors[] = array("errors" => "El campo Valor Tipo Cambio es obligatorio.");	
	}else{
		if (!is_float($orden['ValorTipoCambio'])){
  			$errors[] = array("errors" => "El campo Valor Tipo Cambio debe ser decimal");
  		}
	}

	if($orden['ID_TipoCmpVta'] == ""){
		$errors[] = array("errors" => "El campo ID_TipoCmpVta es obligatorio.");	
	}else{
		if (!is_int($orden['ID_TipoCmpVta'])){
  		$errors[] = array("errors" => "El campo ID_TipoCmpVta debe ser entero");
  	}
	}	

	if($orden['MonedaOrigen'] == ""){
		$errors[] = array("errors" => "El campo MonedaOrigen es obligatorio.");	
	}else{
		if (!is_int($orden['MonedaOrigen'])){
  		$errors[] = array("errors" => "El campo MonedaOrigen debe ser entero");
  	}
	}

	if(trim($orden['FechaTipoCambio']) == ""){
  	$errors[] = array("errors" => "El campo FechaTipoCambio es obligatorio");
  }elseif(!date_valid($orden['FechaTipoCambio'])){
  	$errors[] = array("errors" => "El campo FechaTipoCambio debe ser yyyy-mm-dd");
  }

  if($orden['ID_ModoFact'] == ""){
		$errors[] = array("errors" => "El campo ID_ModoFact es obligatorio.");	
	}else{
		if (!is_int($orden['ID_ModoFact'])){
  		$errors[] = array("errors" => "El campo ID_ModoFact debe ser entero");
  	}else{
  		/*
			|-------------------------------------------------
			| VALIDAR QUE EXISTA CODIGO DE MODO DE FACTURACION
			|-------------------------------------------------
			*/
			$query = $_ci->db->get_where('tab_mod_fac', array('tmf_cod_mfa' => $orden['ID_ModoFact']));
			$modofacturacion = $query->row();

			if (!isset($modofacturacion))
			{		
				$errors[] = array("errors" => "Código ID_ModoFact: '" . $orden['ID_ModoFact'] . "' de Modo de Facturación no se encuentra registrado");	
			}
			//-----------------------------------------------
  	}
	}	

  /*
	|--------------------------------------
	| VALIDAR CLIENTE
	|--------------------------------------
	*/
  if(trim($orden['cliente']['Rut']) == ""){
  	$errors[] = array("errors" => "El campo Rut es obligatorio");
  }else{
  	if (!is_int($orden['cliente']['Rut'])){
  		$errors[] = array("errors" => "El campo Rut debe ser entero");
  	}
  }

  if(trim($orden['cliente']['Digito']) == ""){
  	$errors[] = array("errors" => "El campo Digito es obligatorio");
  }

  if(trim($orden['cliente']['Nombre']) == ""){
  	$errors[] = array("errors" => "El campo Nombre es obligatorio");
  }

  if(trim($orden['cliente']['Giro']) == ""){
  	$errors[] = array("errors" => "El campo Giro es obligatorio");
  }        
  //-------------------------------------

	/*
	|--------------------------------------
	| VALIDAR DETALLE
	|--------------------------------------
	*/
	foreach($detalles as $det){
		
		if($det['Cantidad'] == ""){
			$errors[] = array("errors" => "El campo Cantidad es obligatorio.");
		}else{
			if (!is_float($det['Cantidad'])){
    		$errors[] = array("errors" => "El campo Cantidad debe ser decimal");
			}
		}

		if(isset($det['UnidadMedida'])){
			if($det['UnidadMedida'] == ""){
				$errors[] = array("errors" => "El campo UnidadMedida es obligatorio.");
			}else{
				if (!is_int($det['UnidadMedida'])){
				$errors[] = array("errors" => "El campo UnidadMedida debe ser entero");
				}else{
					/*
					|-------------------------------------------------
					| VALIDAR QUE EXISTA CODIGO DE MODO UNIDAD MEDIDA
					|-------------------------------------------------
					*/
					$query = $_ci->db->get_where('tab_uni_med', array('tum_cod_med' => $det['UnidadMedida']));
					$unidamedida = $query->row();

					if (!isset($unidamedida))
					{		
						$errors[] = array("errors" => "Código UnidadMedida: " . $det['UnidadMedida'] . " no se encuentra registrado");	
					}
					//-----------------------------------------------
				}
				//----
			}
		}		

		if($det['CtaContable'] == ""){
			$errors[] = array("errors" => "El campo CtaContable es obligatorio.");	
		}

		if($det['NetoBruto'] == ""){
			$errors[] = array("errors" => "El campo NetoBruto es obligatorio.");	
		}else{
			if (!is_int($det['NetoBruto'])){
    		$errors[] = array("errors" => "El campo NetoBruto debe ser entero");
    	}
		}

		//if($det['PrecioUnitario'] == "" || $det['PrecioUnitario'] == "0"){		
			//$errors[] = array("errors" => "El campo PrecioUnitario es obligatorio.");	
		//}else{			
			if (!is_float($det['PrecioUnitario'])){
				$errors[] = array("errors" => "El campo PrecioUnitario debe ser decimal");
			}
		//}

		//if($det['PrecioTotal'] == "" || $det['PrecioTotal'] == "0"){		
			//$errors[] = array("errors" => "El campo PrecioTotal es obligatorio.");	
		//}else{
			if (!is_float($det['PrecioTotal'])){
				$errors[] = array("errors" => "El campo PrecioTotal debe ser decimal");
			}
		//}

		$sumDet+= $det['PrecioTotal'];		
	}   		
	//-------------------------------------
	/*
	|--------------------------------------
	| VALIDAR HITO
	|--------------------------------------
	*/
	foreach($hitos as $hit){
					
		if($hit['ID_FormaPago'] == ""){
			$errors[] = array("errors" => "El campo ID_FormaPago es obligatorio.");	
		}

		if($hit['HitoPago'] == ""){
			$errors[] = array("errors" => "El campo HitoPago es obligatorio.");	
		}
		
		if (!is_float($hit['MontoNetoOrigen'])){
    	$errors[] = array("errors" => "El campo MontoNetoOrigen debe ser decimal");
    }		

		if (!is_float($hit['MontoExentoOrigen'])){
    	$errors[] = array("errors" => "El campo MontoExentoOrigen debe ser decimal");
    }
		
		if (!is_float($hit['MontoIVAOrigen'])){
    	$errors[] = array("errors" => "El campo MontoIVAOrigen debe ser decimal");
    }
		
		if (!is_float($hit['MontoTotalOrigen'])){
    	$errors[] = array("errors" => "El campo MontoTotalOrigen debe ser decimal");
    }
		
		if (!is_float($hit['MontoNetoNacional'])){
    	$errors[] = array("errors" => "El campo MontoNetoNacional debe ser decimal");
    }
	
		if (!is_float($hit['MontoExentoNacional'])){
    	$errors[] = array("errors" => "El campo MontoExentoNacional debe ser decimal");
    }
		
		if (!is_float($hit['MontoIVANacional'])){
    	$errors[] = array("errors" => "El campo MontoIVANacional debe ser decimal");
    }
			
		if (!is_float($hit['MontoTotalNacional'])){
    	$errors[] = array("errors" => "El campo MontoTotalNacional debe ser decimal");
    }
		

		if($hit['FechaPago'] == ""){
			$errors[] = array("errors" => "El campo FechaPago es obligatorio.");	
		}else{
			if(!validar_fecha_espanol($hit['FechaPago'])){
				$errors[] = array("errors" => "El campo Fecha debe ser yyyy-mm-dd");
			}			
		}

		//$sumHit+= $hit['MontoNetoNacional'];
		if($hit['MontoNetoNacional'] > 0)
			$sumHit+= $hit['MontoNetoNacional'];
		else{
			$sumHit+= $hit['MontoExentoNacional'];
		}
	} 	

	if ($sumHit > $sumDet){		
		$errors[] = array("errors" => "Monto ingresado en el o los hitos, supera el 100% del pago");	
	}

	if ($sumHit < $sumDet){
		$errors[] = array("errors" => "Monto ingresado en el o los hitos, menor al 100% del pago");
	}
	//---------------------------------------

  return $errors;
}