<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * 
 */
class Orden_model extends CI_Model
{
	public $ID_Comuna;
	public $ID_FormaPago;
	public $ID_ModoFact;
	public $ID_ID_Soc;	
	public $MonedaOrigen;
	public $ID_TipoCmpVta;
	
	public $iRutScd;

	public function set_datos( $data_cruda ){

		foreach ($data_cruda as $nombre_campo => $valor_campo) {
			if(property_exists('Orden_model', $nombre_campo)){
				$this->$nombre_campo = $valor_campo;
			}
		}		

		return $this;
	}

	public function mdl_comunas(){
		
		$this->db->select( 'tmc_cod_com as ID_Comuna, tmc_des_com as Comuna' );		
		$query = $this->db->get('tab_mae_com');		

		foreach($query->result() as $row){
			$row->ID_Comuna     = intval($row->ID_Comuna);
		}		

		return $query->result();
	}

	public function mdl_forma_pago(){
		
		$this->db->select( 'tfp_cod_fpg as ID_FormaPago, tfp_des_fpg as FormaPago' );
		$query = $this->db->get('tab_fma_pgo');		

		foreach($query->result() as $row){
			$row->ID_FormaPago     = intval($row->ID_FormaPago);
		}		

		return $query->result();
	}

	public function mdl_tipo_orden(){
		
		$this->db->select( 'ttc_cod_tcp as ID_TipoCmpVta, ttc_des_tsr as TipoCmpVta' );
		$query = $this->db->get('tab_tip_cmp');		

		foreach($query->result() as $row){
			$row->ID_TipoCmpVta     = intval($row->ID_TipoCmpVta);
		}		

		return $query->result();
	}

	public function mdl_modo_facturacion(){
		
		$this->db->select( 'tmf_cod_mfa as ID_ModoFact, tmf_mod_fac as Modofacturacion' );		
		$this->db->or_where_in('tmf_cod_mfa', array('101','102','108','110'));
		$query = $this->db->get('tab_mod_fac');		

		foreach($query->result() as $row){
			$row->ID_ModoFact     = intval($row->ID_ModoFact);
		}		

		return $query->result();
	}

	public function mdl_sociedad(){

		$this->db->select( 'tsp_cod_sdp as ID_Soc, tsp_rzn_scl as Sociedad' );
		$this->db->where( array('tsp_rut_sdp' => $this->iRutScd));
		$query = $this->db->get('tab_scd_per');	

		if($query){

			if ($query->num_rows() >= 1){

				foreach($query->result() as $row){
					$row->ID_Soc     = intval($row->ID_Soc);
				}				         

				$out = array(
							'err'      => FALSE,
							'mensaje'  => 'RUT de Sociedad cargado con exito',
							'sociedad' => $query->result()							
				);						

			}else{

				$out = array(
							'err'       => TRUE,
							'mensaje'   => 'RUT de Sociedad no existe',
							'sociedad'  => NULL 	
				);			
			}

		}else{

			$out = array(
						'err'       => TRUE,
						'mensaje'   => 'Error al Consultar RUT',
						'error'     => $this->db->_error_message,
						'error_num' => $this->db->_error_number
			);			
		}

		return $out;		
	}

	public function mdl_tipo_moneda(){
		
		$this->db->select( 'ttg_cod_idd as MonedaOrigen, ttg_des_gnr as Moneda' );
		$this->db->where( array('ttg_cod_grp' => 'tip_mon' ));		
		$query = $this->db->get('tab_tbl_gnr');		

		foreach($query->result() as $row){
			$row->MonedaOrigen     = intval($row->MonedaOrigen);
		}		

		return $query->result();
	}
		
	public function mdl_registro_flujo($iTipCta){
		
		$this->db->select( 'trf_cod_rfl, trf_des_rfl' );
		$this->db->where( array('trf_tip_cta' => $iTipCta ));		
		$query = $this->db->get('tab_reg_flj');		

		foreach($query->result() as $row){
			$row->trf_cod_rfl     = intval($row->trf_cod_rfl);
		}		

		return $query->result();
	}
	
	public function mdl_insert_orden($iCodCvt,$iTipCta,$iCodScd,$iRutScd,$iEmiPor,$iFecCmp,$iCndPgo,$iDesCco,$iCodTcp,$iRutPrv,$iDvfPrv,$iNomPrv,$iGirPrv,$iCodCom,$iCtcCmp,$iCgoCmp,$iEmlCmp,$iTelCmp,$iCelCmp,$iCodMon,$iValCmb,$iFecCmb,$iCodMfa,$iObsCmp,$iCodRfl){

		/*
		|------------------------------------------------------------------------------------------
		| VALIDAMOS QUE REGISTRO SE HAYA INSERTADO CORRECTAMENTE ANTES DE INSERTAR NUEVAMENTE OTRO
		|------------------------------------------------------------------------------------------
		*/
		if($iCodScd <> 0){

			$query = $this->db->get_where('tab_ord_cmp', array(
																'toc_num_ocv' => $iCodCvt,
																'tsp_cod_sdp' => $iCodScd)
															);
		}else{

			$queryRUT = $this->db->get_where('tab_scd_per', array('tsp_rut_sdp' => $iRutScd));

			$sRUTScd = $queryRUT->row();

			if (isset($sRUTScd))
			{
				$query = $this->db->get_where('tab_ord_cmp', array(
																	'toc_num_ocv' => $iCodCvt,
																	'tsp_cod_sdp' => $sRUTScd->tsp_cod_sdp)
																);
			}			
		}
		
		$orden = $query->row();

		if (isset($orden))
		{
			$out = array(
						'err'        => TRUE,
						'key'        => FALSE,
						'mensaje'    => 'Registro insertado correctamente',
						'orden_id'   => $orden->toc_cod_cmp,
						'orden_num'  => $orden->toc_num_cmp						
			);
			
			return $out;
		}		
		//------------------------------------------------------------------

		/*[AUT-20221104 : Formación de los Parametros de Entrada]*/
		$iPrm = "";						
		
		$iPrm = $iPrm . "     " . trim($iCodCvt);		
		$iPrm = $iPrm . "   , " . trim($iTipCta);
		$iPrm = $iPrm . "   , " . trim($iCodScd);		
		$iPrm = $iPrm . "   , " . trim($iRutScd);
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iEmiPor)) . "'";
		$iPrm = $iPrm . "   ,'" . trim($iFecCmp) . "'";		
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iCndPgo)) . "'";		
		$iPrm = $iPrm . "   ,'" . trim($iDesCco) . "'";
		$iPrm = $iPrm . "   , " . trim($iCodTcp);		
		$iPrm = $iPrm . "   , " . trim($iRutPrv);
		$iPrm = $iPrm . "   ,'" . trim($iDvfPrv) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iNomPrv)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iGirPrv)) . "'";
		$iPrm = $iPrm . "   , " . trim($iCodCom);
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iCtcCmp)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iCgoCmp)) . "'";
		$iPrm = $iPrm . "   ,'" . trim($iEmlCmp) . "'";
		$iPrm = $iPrm . "   ,'" . trim($iTelCmp) . "'";
		$iPrm = $iPrm . "   ,'" . trim($iCelCmp) . "'";
		$iPrm = $iPrm . "   , " . trim($iCodMon);
		$iPrm = $iPrm . "   ,'" . trim($iValCmb) . "'";
		$iPrm = $iPrm . "   ,'" . trim($iFecCmb) . "'";
		$iPrm = $iPrm . "   , " . trim($iCodMfa);		
		$iPrm = $iPrm . "   ,'" . trim($iObsCmp) . "'";		
		$iPrm = $iPrm . "   , " . trim($iCodRfl);		

		/*[AUT-20221104 : Llamada al Servicio MySQL]*/	
		$sSql = "api_grb_ord_cmp_vta";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);
		
		if ($query->row()->cod_idd != null){
		
			$out = array(
						'err'        => FALSE,						
						'mensaje'    => $query->row()->des_sal,
						'orden_id'   => $query->row()->cod_idd,
						'orden_num'  => $query->row()->num_cmp						
			);			

			$query->next_result(); 
            $query->free_result(); 

		}else{

			$out = array(
						'err'       => TRUE,
						'key'       => TRUE,
						'mensaje'   => $query->row()->des_sal,
						'errores'   => array(
								'orden_id'   => NULL,
								'orden_num'  => NULL
						)
			);			
		}

		return $out;
	}
	
	public function mdl_insert_detalles($iCodCmp,
									    $iCanCmp,
									    $iCodMed,
									    $iCodMon,
									    $iPlnCta,									    
									    $iCodMfa,
									    $iNetBru,
									    $iPrcUnt,
									    $iPrcTot,									    
									    $iDesCmp,									    
									    $iPatVeh){

		$iCodDet = -1;	

		/*[AUT-20221104 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim($iCodDet);
		$iPrm = $iPrm . "   , " . trim($iCodCmp);
		$iPrm = $iPrm . "   ,'" . trim($iCanCmp) . "'";
		$iPrm = $iPrm . "   , " . trim($iCodMed);
		$iPrm = $iPrm . "   , " . trim($iCodMon);
		$iPrm = $iPrm . "   ,'" . trim($iPlnCta) . "'";		
		$iPrm = $iPrm . "   , " . trim($iCodMfa);		
		$iPrm = $iPrm . "   , " . trim($iNetBru);
		$iPrm = $iPrm . "   ,'" . trim($iPrcUnt) . "'";
		$iPrm = $iPrm . "   ,'" . trim($iPrcTot) . "'";		
		$iPrm = $iPrm . "   ,'" . trim($iDesCmp) . "'";		
		$iPrm = $iPrm . "   ,'" . trim($iPatVeh) . "'";		

		/*[AUT-20221104 : Llamada al Servicio MySQL]*/	
		$sSql = "api_grb_det_cmp_vta";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		if ($query->num_rows() == 1){				         

			$out = array(
						'err' => FALSE							
			);			

			$query->next_result(); 
            $query->free_result(); 

		}else{

			$out = array(
						'err'       => TRUE,
						'mensaje'   => 'Error al insertar',
						'error'     => $this->db->_error_message,
						'error_num' => $this->db->_error_number
			);			
		}

		return $out;
	}

	public function mdl_insert_hitos($iCodCmp,
									 $iCodFpg,
									 $iHitPgo,
									 $iMorNet,
									 $iMorExt,
									 $iMorImp,
									 $iMorTot,
									 $iMncNet,
									 $iMncExt,
									 $iMncImp,
									 $iMncTot,
									 $iCodRfl,
									 $iFecPgo){
		$iCodDet = -1;	

		/*[AUT-20221104 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim($iCodDet);
		$iPrm = $iPrm . "   , " . trim($iCodCmp);
		$iPrm = $iPrm . "   , " . trim($iCodFpg);
		$iPrm = $iPrm . "   ,'" . trim($iHitPgo) . "'";	

		$iPrm = $iPrm . "   ,'" . trim($iMorNet) . "'";		
		$iPrm = $iPrm . "   ,'" . trim($iMorExt) . "'";		
		$iPrm = $iPrm . "   ,'" . trim($iMorImp) . "'";	
		$iPrm = $iPrm . "   ,'" . trim($iMorTot) . "'";	
			
		$iPrm = $iPrm . "   ,'" . trim($iMncNet) . "'";		
		$iPrm = $iPrm . "   ,'" . trim($iMncExt) . "'";
		$iPrm = $iPrm . "   ,'" . trim($iMncImp) . "'";		
		$iPrm = $iPrm . "   ,'" . trim($iMncTot) . "'";

		$iPrm = $iPrm . "   , " . trim($iCodRfl);		
		$iPrm = $iPrm . "   ,'" . trim($iFecPgo) . "'";

		/*[AUT-20221104 : Llamada al Servicio MySQL]*/	
		$sSql = "api_grb_pgo_cmp_vta";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		if ($query->num_rows() == 1){			 	         

			$out = array(
						'err'       => FALSE							
			);			

			$query->next_result(); 
            $query->free_result();

		}else{

			$out = array(
						'err'       => TRUE,
						'mensaje'   => 'Error al insertar',
						'error'     => $this->db->_error_message,
						'error_num' => $this->db->_error_number
			);			
		}

		return $out;
	}

	public function mdl_sol_apb_vta($iCodCmp){

		/*[AUT-20221205 : Formación de los Parametros de Entrada]*/
		$iPrm = "";		
		
		$iPrm = $iPrm . "     " . trim($iCodCmp);
		
		/*[AUT-20221205 : Llamada al Servicio MySQL]*/	
		$sSql = "api_sol_apb_cmp_vta";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		if ($query->num_rows() == 1){			 	         

			$out = array(
						'err'       => FALSE							
			);			

			$query->next_result(); 
            $query->free_result();

		}else{

			$out = array(
						'err'       => TRUE,
						'mensaje'   => 'Error al insertar',
						'error'     => NULL,
						'error_num' => NULL
			);			
		}

		return $out;
	}
	
}		